;******************************************************************************
; Procedure to change the color table to one that we like.
; If generating a monochrome graph explicitly set the R,G,B values the same for
; the first four color indices to produce shades of gray, or it'll still come
; out color on color monitors. 
;
; The color table below is for background and data line colors
;   0  black
;   1  pastel pink
;   2  pastel orange
;   3  pastel green
;   4  pastel yellow    was 255,255,76
;   5  light gray
;   6  light yellow
; 7-9  white (spares)
;  10  black
;  11  bright red
;  12  bright yellow
;  13  bright blue
;  14  bright orange
;  15  bright dark green
; 16-255  white (spares)
;******************************************************************************

PRO set_color_table
COMMON colors, r_orig, g_orig, b_orig, r_curr, g_curr, b_curr

  r_curr = [0, 255, 244, 111, 255, 243, 255, 255, 255, 255, $
            0, 255, 255,   0, 255,  10, bytarr(240)+255]
  g_curr = [0, 182, 164, 220, 255, 243, 255, 255, 255, 255, $
            0,   0, 255,   0, 153, 166, bytarr(240)+255]
  b_curr = [0, 193,  96, 111,  76, 243, 243, 255, 255, 255, $
            0,   0,   0, 255,  25,   8, bytarr(240)+255]
  RETURN
END

